/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.sets;

import Data_Structures.ADTs.Pairable;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.small.gui_handle;
import Game_Engine.GUI.Interfaces.Pingable;
import java.util.Iterator;

public class Indication_Set<T extends Obj>
extends Obj
implements Iterable<T>,
Pingable {
    UBA<T> data = new UBA();
    int swap1 = -1;
    int swap2 = -1;
    private boolean revert = false;

    @Override
    public void update() {
        this.handle_swaps();
    }

    private void handle_swaps() {
        gui_handle moving_elem = gui_handle.handle_held;
        int moving_index = this.getIndex(moving_elem);
        if (moving_index < 0) {
            return;
        }
        int len = this.data.size();
        int current_index = 0;
        while (current_index < len) {
            if (current_index != moving_index) {
                Obj o = (Obj)this.data.get(current_index);
                int bounds_reduce = o.getH() / 2;
                boolean c1 = o.collision(o.x_start - (double)bounds_reduce, o.y_start - (double)bounds_reduce, moving_elem);
                boolean c2 = o.collision(o.x_start + (double)bounds_reduce, o.y_start + (double)bounds_reduce, moving_elem);
                if (c1 && c2) {
                    if (this.swap1 != -1) {
                        Obj o2 = (Obj)this.data.get(this.swap2);
                        this.swap(this.swap1, this.swap2);
                        o2.revert();
                        this.swap1 = -1;
                        this.swap2 = -1;
                        return;
                    }
                    this.swap1 = current_index;
                    this.swap2 = moving_index;
                    this.swap(current_index, moving_index);
                    o.revert();
                    return;
                }
            }
            ++current_index;
        }
    }

    private int getIndex(Obj input) {
        int len = this.data.size();
        int i = 0;
        while (i < len) {
            Obj o = (Obj)this.data.get(i);
            if (o == input) {
                return i;
            }
            if (o instanceof Obj_union && ((Obj_union)o).contains(input)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void swap(int i1, int i2) {
        Obj o1 = (Obj)this.data.get(i1);
        Obj o2 = (Obj)this.data.get(i2);
        this.data.swap(i1, i2);
        double tempX = o1.x_start;
        double tempY = o1.y_start;
        o1.x_start = o2.x_start;
        o1.y_start = o2.y_start;
        o2.x_start = tempX;
        o2.y_start = tempY;
    }

    public void push(T o) {
        this.data.push(o);
    }

    public T pop() {
        return (T)((Obj)this.data.pop());
    }

    public UBA<T> getData() {
        return this.data;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public void global_mouseR() {
        if (this.swap1 != -1) {
            this.revert = true;
        }
    }

    @Override
    public void endStep() {
        if (!this.revert) {
            return;
        }
        this.revert = false;
        if (this.swap1 == -1) {
            return;
        }
        Obj o1 = (Obj)this.data.get(this.swap1);
        Obj o2 = (Obj)this.data.get(this.swap2);
        this.swap(this.swap1, this.swap2);
        o1.revert();
        o2.revert();
        this.swap1 = -1;
        this.swap2 = -1;
    }

    @Override
    public boolean flag() {
        return this.revert;
    }

    @Override
    public void setFlag(boolean flag) {
        throw new Error("Please do not do this!");
    }

    public Pairable<Integer> getSwaps() {
        List<Integer> output = new List<Integer>();
        output.add(this.swap1);
        output.add(this.swap2);
        return output;
    }

    public int size() {
        return this.data.size();
    }
}

